//
//  Formatters.swift
//  Do It
//
//  Created by Jim Dovey on 10/28/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import Foundation

enum Formatters {
    static let monthAndYear: DateFormatter = {
        let formatter = DateFormatter()
        formatter.dateFormat = "MMM yyyy"
        return formatter
    }()
    
    static let mediumDate: DateFormatter = {
        let f = DateFormatter()
        f.dateStyle = .medium
        f.timeStyle = .none
        f.doesRelativeDateFormatting = true
        return f
    }()
    
    static let shortDate: DateFormatter = {
        let f = DateFormatter()
        f.dateStyle = .short
        f.timeStyle = .none
        f.doesRelativeDateFormatting = true
        return f
    }()

    static let shortDateAndTime: DateFormatter = {
        let f = DateFormatter()
        f.dateStyle = .short
        f.timeStyle = .short
        f.doesRelativeDateFormatting = true
        return f
    }()
    
    static let percentage: NumberFormatter = {
        let f = NumberFormatter()
        f.numberStyle = .percent
        return f
    }()

    static func optionalTime(in date: Date) -> DateFormatter {
        let components = Calendar.current.dateComponents([.hour, .minute], from: date)
        switch (components.hour, components.minute) {
        case (0, 0):
            return shortDate
        default:
            return shortDateAndTime
        }
    }
}

class NilStringFormatter: Formatter {
    override func string(for obj: Any?) -> String? {
        if obj == nil { return "" }
        guard let str = obj as? String else { return super.string(for: obj) }
        return str
    }
    override func getObjectValue(_ obj: AutoreleasingUnsafeMutablePointer<AnyObject?>?, for string: String, errorDescription error: AutoreleasingUnsafeMutablePointer<NSString?>?) -> Bool {
        if string.isEmpty {
            obj?.pointee = nil
        }
        else {
            obj?.pointee = string as NSString
        }
        return true
    }
}
